* Title: Adding a Video
* Slug: new-video

================================================================

To add a video, go to <{path}>/help/videos<{/path}> subfolder of the module that you documenting and add create a new <{code}>01. My Video.md<{/code}> file. 

File naming convention is same as pages, but lets repeat it:

* With <{code}>01.<{/code}> you said the ordering position of the video in the video group. To change video ordering in the group, simply rename them so these bits of file name are in order that you like. Video order number is ignored when video is presented to the user so users will never see them,
* <{code}>My Video<{/code}> is the name of your video. If <{code}>title<{/code}> and/or <{code}>slug<{/code}> attributes are not defined in the vide file, this value will be used as video title, and for video slug (system will automatically convert it to <{code}>my-video<{/code}> format).

While video files can have content block defined, it's of no use because it is never displayed. System will only use attributes, and here are the ones that are available:

### Title

Video title (optional). If it is omitted, system will use name of the video file (sans order number and file extension) as video title.

### Slug

Page slug (optional). If it is omitted, system will automatically convert title to slug format (<{term}>My Cool Video<{/term}> will become <{term}>my-cool-video<{/term}>).

### Group

Name of the group that this video should be listed under. Groups are defined by the application. If this attribute is omitted or if it points to a group that is not defined by the application, system will put it under the default group.

### Url

URL to video source (required). Currently system expects that you provide URL to 360p version of the video.

### Play Time

Informative play time in <{term}>MM:SS<{/term}> format. This bit of information system does not read from the video file itself (because it would need to open it), but we need it to present it to the user. If omitted, system will display <{code}>-:--<{/code}>.

### Show To

List of <{page name="user-groups"}>user groups<{/page}> that this video clip is visible to. When this attribute is present, video clip will be displayed only to users that belong to groups listed in it.

### Hide From

List of <{page name="user-groups"}>user groups<{/page}> that this video clip should be hidden from.